require( "locations/grytviken/stations.lua" );
require( "locations/grytviken/player.lua" );
require( "locations/grytviken/customers.lua" );
require( "locations/grytviken/chocolates.lua" );
require( "locations/grytviken/backgrounds.lua" );
require( "locations/grytviken/plot.lua" );

require( "locations/iquitos/stations.lua" );
require( "locations/iquitos/player.lua" );
require( "locations/iquitos/customers.lua" );
require( "locations/iquitos/chocolates.lua" );
require( "locations/iquitos/backgrounds.lua" );
require( "locations/iquitos/plot.lua" );

require( "locations/gaberoun/stations.lua" );
require( "locations/gaberoun/player.lua" );
require( "locations/gaberoun/customers.lua" );
require( "locations/gaberoun/chocolates.lua" );
require( "locations/gaberoun/backgrounds.lua" );
require( "locations/gaberoun/plot.lua" );

require( "locations/krakatoa/stations.lua" );
require( "locations/krakatoa/player.lua" );
require( "locations/krakatoa/customers.lua" );
require( "locations/krakatoa/chocolates.lua" );
require( "locations/krakatoa/backgrounds.lua" );
require( "locations/krakatoa/plot.lua" );

require( "locations/namche/stations.lua" );
require( "locations/namche/player.lua" );
require( "locations/namche/customers.lua" );
require( "locations/namche/chocolates.lua" );
require( "locations/namche/backgrounds.lua" );
require( "locations/namche/plot.lua" );

require( "locations/kamchatka/stations.lua" );
require( "locations/kamchatka/player.lua" );
require( "locations/kamchatka/customers.lua" );
require( "locations/kamchatka/chocolates.lua" );
require( "locations/kamchatka/backgrounds.lua" );
require( "locations/kamchatka/plot.lua" );

require( "locations/tutorials.lua" );

require( "locations/chocolateposse.lua" );
require( "scripts/chocshopstyle.lua" );
require( "scripts/hud.lua" );
require( "scripts/transitions.lua" );

questW = 245;
questH = 250;

MakeDialog
{
	name = "game_window",
	
	Bitmap
	{
		name = "shop_background",
		x = 0, y = 0, w = 800, h = 600,
		image="ui/fullscreendialog",
		
		RActiveTextLayer{
			name = "text_window",
			x = 0,
			y = 0,
			w = kMax,
			h = kMax
		},
		
		ShopWindow
		{
			x = 0, y = 0, w = kMax, h = kMax,
			
			VShopHud
	        {
		        x = 800 - 334, y = 0, w = 334, h = 200,
		        name = "shop_hud",
		        Group(ChocolateHud),	
	        },
	        VQuestWindow{
	            name = "quest_window",
	            x = 0,
	            y = 0,
	            w = questW,
	            h = questH,
	            colors = {FColor(1.0,1.0,0), FColor(0,1.0,0), FColor(1.0,0,0)},
	            --outlinecolor = WhiteColor,
	            --outlinesize = 1,
	            marginY = 15,
	            KSplit9Image{
	                name = "background",
	                x = 0,
	                y = -questH - 40,
	                w = questW,
	                h = questH,
	                image = "ui/backgrounds/split9_dialog_small",
	                x1 = 40,
	                y1 = 40,
	                x2 = 40,
	                y2 = 40,
	            },
	            Text{
	                x = 10,
	                w = questW - 27,
	                h = 18,
	                font = {edwardian_medium, 18, WhiteColor},
	                flags = kHAlignLeft + kVAlignTop,
	                label = "quest_header_1",
	            },
	            Text{
	                x = 10,
	                w = questW - 27,
	                h = 18,
	                font = {edwardian_medium, 18, WhiteColor},
	                flags = kHAlignRight + kVAlignTop,
	                label = "quest_header_2",
	            },
	            Text{
	                name = "txt_quest_names",
	                y = 18,
	                x = 10,
	                w = questW - 27,
	                h = questH - 20,
	                font = {edwardian_medium, 15, BlackColor},
	                flags = kHAlignLeft + kVAlignTop,
	            },
	            Text{
	                name = "txt_quest_status",
	                y = 18,
	                x = 10,
	                w = questW - 27,
	                h = questH - 20,
	                font = {edwardian_medium, 15, BlackColor},
	                flags = kHAlignRight + kVAlignTop,
	            },
	        },
			--------------------------------------Set Object Lists
			tutorials = game_tutorials,
			posse = chocolatePosse,
			--customer_objects = customerObjects,
			
			location_grytviken = {
				music_01 =		"audio/music/grytviken.ogg",
				
				background =	grytvikenBackground,
				stations =		grytvikenStations,
				player =		iquitosPlayer,
				customers =		grytvikenLocals,
				objects =       grytvikenObjects,
				chocolates =	grytvikenChocolates,
				plot =			grytvikenPlot,
			},
			location_iquitos = {
				music_01 =		"audio/music/iquitos.ogg",
				
				background =	iquitosBackground,
				stations =		iquitosStations,
				player =		iquitosPlayer,
				customers =		iquitosLocals,
				objects =       iquitosObjects,
				chocolates =	iquitosChocolates,
				plot =			iquitosPlot,
			},
			location_gaberoun = {
				music_01 =		"audio/music/gaberoun.ogg",
				
				background =	gaberounBackground,
				stations =		gaberounStations,
				player =		iquitosPlayer,
				customers =		gaberounLocals,
				objects =       gaberounObjects,
				chocolates =	gaberounChocolates,
				plot =			gaberounPlot,
			},
			location_krakatoa = {
				music_01 =		"audio/music/krakatoa.ogg",
				
				background =	krakatoaBackground,
				stations =		krakatoaStations,
				player =		iquitosPlayer,
				customers =		krakatoaLocals,
				objects =       krakatoaObjects,
				chocolates =	krakatoaChocolates,
				plot =			krakatoaPlot,
			},
			location_namche = {
				music_01 =		"audio/music/namche.ogg",
				
				background =	namcheBackground,
				stations =		namcheStations,
				player =		iquitosPlayer,
				customers =		namcheLocals,
				objects =       namcheObjects,
				chocolates =	namcheChocolates,
				plot =			namchePlot,
			},
			location_kamchatka = {
				music_01 =		"audio/music/kamchatka.ogg",
				
				background =	kamchatkaBackground,
				stations =		kamchatkaStations,
				player =		iquitosPlayer,
				customers =		kamchatkaLocals,
				objects =       kamchatkaObjects,
				chocolates =	kamchatkaChocolates,
				plot =			kamchatkaPlot,
			},
			
			SetStyle(CSMainMenuButton),
			Button
			{
				name = "game_debug",
				x = 5, y = kMax - 100,
				flags = kVAlignCenter + kHAlignCenter,
				label = "#Debug",
				command = 
					function()
						DoDebug();
					end,
			},
			Button
			{
				name = "game_cheats",
				x = 5, y = kMax - 270,
				label = "#Cheats",
				flags = kVAlignCenter + kHAlignCenter,
				command = 
					function()
						DisplayDialog { "scripts/cheats.lua", context = "game" };
					end
			},
		},
	},
}
InsideGame(true);

EnableWindow("game_cheats", IsEnabled(kCheatMode));
EnableWindow("game_debug", GetConfig("game_debug") == "1");

